package cc.zhaoac.tool.common.aop;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * RequestInheritableThread-AOP
 * 子线程共享主线程request信息
 *
 * @author zhaoanchi
 * @version 1.0
 * @since 2023-10-13 13:45
 */
@Aspect
@Component
public class RequestHolderAspect {
    @Before("@annotation(cc.zhaoac.tool.common.annotation.RequestInheritableThread)")
    public void doBefore(JoinPoint joinPoint) {
        ServletRequestAttributes sra = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        RequestContextHolder.setRequestAttributes(sra, true);
    }
}
