package cc.zhaoac.tool.common.databind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Optional;
import org.springframework.util.ObjectUtils;

/**
 * 字符串trim
 * @author zhaoanchi
 * @version 1.0
 * @since 2023-09-25 13:15
 */
public class TrimJsonDeSerializer extends JsonDeserializer<String> {


    @Override
    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (ObjectUtils.isEmpty(jsonParser)) {
            return null;
        }
        return Optional.ofNullable(jsonParser.getText()).map(String::trim).orElse(null);
    }
}
