package cc.zhaoac.tool.common.function;

import cc.zhaoac.tool.common.excetion.ExecutorException;
import cc.zhaoac.tool.common.excetion.ServiceException;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

/**
 * @author zhaoanchi
 * @version 1.0
 * @program pie-engine-uav-monitor
 * @description 函数工具类
 * @date 2023-05-29 14:16
 */
@Slf4j
@UtilityClass
public class FunctionUtil {

    private static final Executor EXECUTOR = SpringUtil.getBean(Executor.class);

    /* ******************** 异步任务 ******************** */

    /**
     * 异步方法
     *
     * @param runnable 回调方法
     */
    public static void execute(Runnable runnable) {
        try {
            EXECUTOR.execute(runnable);
        } catch (Exception e) {
            throw new ExecutorException(e);
        }
    }

    /**
     * 异步方法
     *
     * @param param1   参数1
     * @param param2   参数2
     * @param consumer 回调方法
     * @param <P1>     参数类型1
     * @param <P2>     参数类型2
     */
    public static <P1, P2> void execute(P1 param1, P2 param2, BiConsumer<P1, P2> consumer) {
        try {
            Runnable runnable = () -> consumer.accept(param1, param2);
            EXECUTOR.execute(runnable);
        } catch (Exception e) {
            throw new ExecutorException(e);
        }
    }

    /**
     * 执行任务
     *
     * @param executorService ExecutorService
     * @param callable        回调
     * @param <T>             返回的结果集Future泛型
     * @return Future泛型
     */
    public static <T> Future<T> submit(ExecutorService executorService, Callable<T> callable) {
        return executorService.submit(callable);
    }


    /* ****************************** 分支判断 ****************************** */
    /* ****************************** 分支判断 ****************************** */

    /**
     * @param flag 条件
     * @return 异常Consumer
     */
    public static ThrowMsgExceptionConsumer throwMsgIsTrue(boolean flag) {
        return (errorMessage -> {
            if (flag) {
                throw new ServiceException(errorMessage);
            }
        });
    }

    /**
     * @param flag 条件
     * @return 异常Consumer
     */
    public static ThrowExceptionConsumer throwIsTrue(boolean flag) {
        return (e -> {
            if (flag) {
                throw e;
            }
        });
    }

    /**
     * 参数为true或false时，分别进行不同的操作
     *
     * @param flag 条件
     * @return 双分支操作
     */
    public static BiBranchHandle isTrueOrFalse(boolean flag) {
        return ((trueHandle, falseHandle) -> {
            if (flag) {
                trueHandle.run();
            } else {
                falseHandle.run();
            }
        });
    }

    /**
     * 参数为true或false时，分别进行不同的操作
     *
     * @param flag 条件
     * @return 双分支操作
     */
    public static <T> BiBranchSupplierHandle<T> isTrueOrFalseReValue(boolean flag) {
        return ((trueHandle, falseHandle) -> {
            if (flag) {
                return trueHandle.get();
            } else {
                return falseHandle.get();
            }
        });
    }

    /**
     * 参数为true时，进行操作
     *
     * @param flag 条件
     * @return 单分支操作
     */
    public static SingleBranchHandle isTrue(boolean flag) {
        return trueHandle -> {
            if (flag) {
                trueHandle.run();
            }
        };
    }

    /**
     * 参数为空或不为空时，分别进行不同的操作
     *
     * @param t 参数
     * @return 空值与非空值分支处理
     **/
    public static <T> PresentOrElseHandler<T> isBlankOrNoBlank(T t) {
        return (consumer, runnable) -> {
            if (ObjectUtil.isEmpty(t)) {
                runnable.run();
            } else {
                consumer.accept(t);
            }
        };
    }
}
