package cc.zhaoac.tool.common.function;

import java.util.function.Consumer;

/**
 * @author zhaoanchi
 * @version 1.0
 * @program pie-engine-uav-monitor
 * @description 非空判断处理
 * @date 2023-06-05 16:34
 */
@FunctionalInterface
public interface PresentOrElseHandler<T> {
    /**
     * 值不为空时执行消费操作
     * 值为空时执行其他的操作
     *
     * @param action 值不为空时，执行的消费操作
     * @param emptyAction 值为空时，执行的操作
     **/
    void presentOrElseHandle(Consumer<? super T> action, Runnable emptyAction);
}
