/*
 * Decompiled with CFR 0.152.
 */
package cc.zhaoac.tool.common.api;

import cc.zhaoac.tool.common.api.IResultCode;
import cc.zhaoac.tool.common.api.ResultCode;
import cc.zhaoac.tool.common.utils.Faith;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.lang.Nullable;

@ApiModel(description="\u8fd4\u56de\u4fe1\u606f")
public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u72b6\u6001\u7801", required=true)
    private int code;
    @ApiModelProperty(value="\u662f\u5426\u6210\u529f", required=true)
    private boolean success;
    @ApiModelProperty(value="\u627f\u8f7d\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u8fd4\u56de\u6d88\u606f", required=true)
    private String msg;

    private R(IResultCode resultCode) {
        this(resultCode, null, resultCode.getMessage());
    }

    private R(IResultCode resultCode, String msg) {
        this(resultCode, null, msg);
    }

    private R(IResultCode resultCode, T data) {
        this(resultCode, data, resultCode.getMessage());
    }

    private R(IResultCode resultCode, T data, String msg) {
        this(resultCode.getCode(), data, msg);
    }

    private R(int code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.success = ResultCode.SUCCESS.code == code;
    }

    public static boolean isSuccess(@Nullable R<?> result) {
        return Optional.ofNullable(result).map(x -> Faith.nullSafeEquals(ResultCode.SUCCESS.code, x.code)).orElse(Boolean.FALSE);
    }

    public static boolean isNotSuccess(@Nullable R<?> result) {
        return !R.isSuccess(result);
    }

    public static <T> R<T> data(T data) {
        return R.data(data, "\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> R<T> data(T data, String msg) {
        return R.data(200, data, msg);
    }

    public static <T> R<T> data(int code, T data, String msg) {
        return new R<T>(code, data, data == null ? "\u6682\u65e0\u627f\u8f7d\u6570\u636e" : msg);
    }

    public static <T> R<T> success(String msg) {
        return new R<T>((IResultCode)ResultCode.SUCCESS, msg);
    }

    public static <T> R<T> success(IResultCode resultCode) {
        return new R<T>(resultCode);
    }

    public static <T> R<T> success(IResultCode resultCode, String msg) {
        return new R<T>(resultCode, msg);
    }

    public static <T> R<T> fail(String msg) {
        return new R<T>((IResultCode)ResultCode.FAILURE, msg);
    }

    public static <T> R<T> fail(int code, String msg) {
        return new R<Object>(code, null, msg);
    }

    public static <T> R<T> fail(IResultCode resultCode) {
        return new R<T>(resultCode);
    }

    public static <T> R<T> fail(IResultCode resultCode, String msg) {
        return new R<T>(resultCode, msg);
    }

    public static <T> R<T> status(boolean flag) {
        return flag ? R.success("\u64cd\u4f5c\u6210\u529f") : R.fail("\u64cd\u4f5c\u5931\u8d25");
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", success=" + this.isSuccess() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ")";
    }

    public R() {
    }
}

