/*
 * Decompiled with CFR 0.152.
 */
package cc.zhaoac.tool.common.function;

import cc.zhaoac.tool.common.excetion.ExecutorException;
import cc.zhaoac.tool.common.excetion.ServiceException;
import cc.zhaoac.tool.common.function.BiBranchHandle;
import cc.zhaoac.tool.common.function.BiBranchSupplierHandle;
import cc.zhaoac.tool.common.function.PresentOrElseHandler;
import cc.zhaoac.tool.common.function.SingleBranchHandle;
import cc.zhaoac.tool.common.function.ThrowExceptionConsumer;
import cc.zhaoac.tool.common.function.ThrowMsgExceptionConsumer;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionUtil {
    private static final Logger log = LoggerFactory.getLogger(FunctionUtil.class);
    private static final Executor EXECUTOR = (Executor)SpringUtil.getBean(Executor.class);

    public static void execute(Runnable runnable) {
        try {
            EXECUTOR.execute(runnable);
        }
        catch (Exception e) {
            throw new ExecutorException(e);
        }
    }

    public static <P1, P2> void execute(P1 param1, P2 param2, BiConsumer<P1, P2> consumer) {
        try {
            Runnable runnable = () -> consumer.accept(param1, param2);
            EXECUTOR.execute(runnable);
        }
        catch (Exception e) {
            throw new ExecutorException(e);
        }
    }

    public static <T> Future<T> submit(ExecutorService executorService, Callable<T> callable) {
        return executorService.submit(callable);
    }

    public static ThrowMsgExceptionConsumer throwMsgIsTrue(boolean flag) {
        return errorMessage -> {
            if (flag) {
                throw new ServiceException(errorMessage);
            }
        };
    }

    public static ThrowExceptionConsumer throwIsTrue(boolean flag) {
        return e -> {
            if (flag) {
                throw e;
            }
        };
    }

    public static BiBranchHandle isTrueOrFalse(boolean flag) {
        return (trueHandle, falseHandle) -> {
            if (flag) {
                trueHandle.run();
            } else {
                falseHandle.run();
            }
        };
    }

    public static <T> BiBranchSupplierHandle<T> isTrueOrFalseReValue(boolean flag) {
        return (trueHandle, falseHandle) -> {
            if (flag) {
                return trueHandle.get();
            }
            return falseHandle.get();
        };
    }

    public static SingleBranchHandle isTrue(boolean flag) {
        return trueHandle -> {
            if (flag) {
                trueHandle.run();
            }
        };
    }

    public static <T> PresentOrElseHandler<T> isBlankOrNoBlank(T t) {
        return (consumer, runnable) -> {
            if (ObjectUtil.isEmpty((Object)t)) {
                runnable.run();
            } else {
                consumer.accept(t);
            }
        };
    }

    private FunctionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

