/*
 * Decompiled with CFR 0.152.
 */
package cc.zhaoac.tool.common.utils;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;

public final class Faith {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String toStr(Object str) {
        return Faith.toStr(str, "");
    }

    public static String toStr(Object str, String defaultValue) {
        if (null == str) {
            return defaultValue;
        }
        return String.valueOf(str);
    }

    public static int toInt(Object value) {
        return Faith.toInt(String.valueOf(value));
    }

    public static int toInt(Object value, int defaultValue) {
        return Faith.toInt(String.valueOf(value), defaultValue);
    }

    public static Double toDouble(Object value) {
        return Faith.toDouble(String.valueOf(value), (Double)-1.0);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        return Faith.toDouble(String.valueOf(value), defaultValue);
    }

    public static long toLong(Object value) {
        return Faith.toLong(String.valueOf(value));
    }

    public static long toLong(Object value, long defaultValue) {
        return Faith.toLong(String.valueOf(value), defaultValue);
    }

    public static int toInt(String str) {
        return Faith.toInt(str, -1);
    }

    public static int toInt(@Nullable String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return Faith.toLong(str, 0L);
    }

    public static long toLong(@Nullable String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Double toDouble(String value) {
        return Faith.toDouble(value, null);
    }

    public static Double toDouble(@Nullable String value, Double defaultValue) {
        if (value != null) {
            return Double.valueOf(value.trim());
        }
        return defaultValue;
    }

    public static Float toFloat(String value) {
        return Faith.toFloat(value, null);
    }

    public static Float toFloat(@Nullable String value, Float defaultValue) {
        if (value != null) {
            return Float.valueOf(value.trim());
        }
        return defaultValue;
    }

    public static Float toFloat(Object value) {
        return Faith.toFloat(String.valueOf(value), Float.valueOf(-1.0f));
    }

    public static Float toFloat(Object value, Float defaultValue) {
        return Faith.toFloat(String.valueOf(value), defaultValue);
    }

    public static Boolean toBoolean(Object value) {
        return Faith.toBoolean(value, null);
    }

    public static Boolean toBoolean(Object value, Boolean defaultValue) {
        if (value != null) {
            String val = String.valueOf(value);
            val = val.toLowerCase().trim();
            return Boolean.parseBoolean(val);
        }
        return defaultValue;
    }

    public static String to62String(long i) {
        int radix = DIGITS.length;
        char[] buf = new char[65];
        int charPos = 64;
        for (i = -i; i <= (long)(-radix); i /= (long)radix) {
            buf[charPos--] = DIGITS[(int)(-(i % (long)radix))];
        }
        buf[charPos] = DIGITS[(int)(-i)];
        return new String(buf, charPos, 65 - charPos);
    }

    public static boolean isEmpty(@Nullable Object obj) {
        return ObjectUtil.isEmpty((Object)obj);
    }

    public static boolean isNotEmpty(@Nullable Object obj) {
        return !ObjectUtil.isEmpty((Object)obj);
    }

    public static boolean isNotEmpty(@Nullable Object[] array) {
        return ObjectUtil.isNotEmpty((Object)array);
    }

    public static boolean isEmpty(@Nullable Object[] array) {
        return ObjectUtil.isEmpty((Object)array);
    }

    public static boolean hasEmpty(Object ... os) {
        for (Object o : os) {
            if (!Faith.isEmpty(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean allEmpty(Object ... os) {
        for (Object o : os) {
            if (Faith.isEmpty(o)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(@Nullable CharSequence cs) {
        return CharSequenceUtil.isBlank((CharSequence)cs);
    }

    public static boolean isNotBlank(@Nullable CharSequence cs) {
        return CharSequenceUtil.isNotBlank((CharSequence)cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object)css)) {
            return true;
        }
        return Stream.of(css).anyMatch(CharSequenceUtil::isBlank);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object)css)) {
            return false;
        }
        return Stream.of(css).allMatch(CharSequenceUtil::isNotBlank);
    }

    public static boolean equals(Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static boolean equalsSafe(@Nullable Object o1, @Nullable Object o2) {
        return Faith.nullSafeEquals(o1, o2);
    }

    public static StringBuilder appendBuilder(StringBuilder sb, CharSequence ... strs) {
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static String[] toStrArray(String str) {
        return Faith.toStrArray(",", str);
    }

    public static String[] toStrArray(String split, String str) {
        if (CharSequenceUtil.isBlank((CharSequence)str)) {
            return new String[0];
        }
        return str.split(split);
    }

    @Nullable
    public static String cleanIdentifier(@Nullable String param) {
        if (param == null) {
            return null;
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            paramBuilder.append(c);
        }
        return paramBuilder.toString();
    }

    public static boolean nullSafeEquals(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return Faith.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    private Faith() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

