/*
 * Decompiled with CFR 0.152.
 */
package cc.zhaoac.tool.common.utils;

import cc.zhaoac.tool.common.excetion.Exceptions;
import cn.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.lang.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private final XPath path;
    private final Document doc;
    private static volatile boolean preventedXXE = false;

    private XmlUtil(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = XmlUtil.getDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.parse(inputSource);
        this.path = XmlUtil.getXpathFactory().newXPath();
    }

    private static XmlUtil create(InputSource inputSource) {
        try {
            return new XmlUtil(inputSource);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static XmlUtil of(InputStream is) {
        InputSource inputSource = new InputSource(is);
        return XmlUtil.create(inputSource);
    }

    public static XmlUtil of(String xmlStr) {
        StringReader sr = new StringReader(xmlStr.trim());
        InputSource inputSource = new InputSource(sr);
        XmlUtil xmlUtil = XmlUtil.create(inputSource);
        IoUtil.close((Closeable)sr);
        return xmlUtil;
    }

    private Object evalXpath(String expression, @Nullable Object item, QName returnType) {
        item = null == item ? this.doc : item;
        try {
            return this.path.evaluate(expression, item, returnType);
        }
        catch (XPathExpressionException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public String getString(String expression) {
        return (String)this.evalXpath(expression, null, XPathConstants.STRING);
    }

    public Boolean getBoolean(String expression) {
        return (Boolean)this.evalXpath(expression, null, XPathConstants.BOOLEAN);
    }

    public Number getNumber(String expression) {
        return (Number)this.evalXpath(expression, null, XPathConstants.NUMBER);
    }

    public Node getNode(String expression) {
        return (Node)this.evalXpath(expression, null, XPathConstants.NODE);
    }

    public NodeList getNodeList(String expression) {
        return (NodeList)this.evalXpath(expression, null, XPathConstants.NODESET);
    }

    public String getString(Object node, String expression) {
        return (String)this.evalXpath(expression, node, XPathConstants.STRING);
    }

    public Boolean getBoolean(Object node, String expression) {
        return (Boolean)this.evalXpath(expression, node, XPathConstants.BOOLEAN);
    }

    public Number getNumber(Object node, String expression) {
        return (Number)this.evalXpath(expression, node, XPathConstants.NUMBER);
    }

    public Node getNode(Object node, String expression) {
        return (Node)this.evalXpath(expression, node, XPathConstants.NODE);
    }

    public NodeList getNodeList(Object node, String expression) {
        return (NodeList)this.evalXpath(expression, node, XPathConstants.NODESET);
    }

    public Map<String, String> toMap() {
        Element root = this.doc.getDocumentElement();
        HashMap<String, String> params = new HashMap<String, String>(16);
        NodeList list = root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            params.put(node.getNodeName(), node.getTextContent());
        }
        return params;
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = XmlHelperHolder.documentBuilderFactory;
        if (!preventedXXE) {
            XmlUtil.preventXxe(dbf);
        }
        return dbf;
    }

    private static void preventXxe(DocumentBuilderFactory dbf) throws ParserConfigurationException {
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        preventedXXE = true;
    }

    private static XPathFactory getXpathFactory() {
        return XmlHelperHolder.xPathFactory;
    }

    private static class XmlHelperHolder {
        private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        private static XPathFactory xPathFactory = XPathFactory.newInstance();

        private XmlHelperHolder() {
        }
    }
}

