package cc.zhaoac.faith.tool.geotool.convert;

import cc.zhaoac.faith.tool.geotool.exception.NoSupportTypeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 解析器公工厂类
 *
 * @author zhaoanchi
 * @version 1.0
 * @since 2023-10-18 14:09
 */
public class FileParserFactory {
    private FileParserFactory() {
        parser.put(FileType.GEOJSON.getName(), new GeoJsonFileParser());
        parser.put(FileType.JSON.getName(), new GeoJsonFileParser());
        parser.put(FileType.SHP.getName(), new ShpFileParser());
        parser.put(FileType.KMZ.getName(), new KmzFileParser());
        parser.put(FileType.KML.getName(), new KmzFileParser());
    }

    public static final FileParserFactory INSTANCE = new FileParserFactory();

    /**
     * 解析器Map[拓展名, 解析器]
     */
    private final Map<String, IFileParser> parser = new HashMap<>(16);


    /**
     * 获取文件解析器
     * @param extName 拓展名
     * @return 文件解析器 {@link IFileParser}
     */
    public IFileParser getParser(String extName) {
        return Optional.ofNullable(parser.get(extName.toLowerCase()))
                .orElseThrow(() -> new NoSupportTypeException("ExtName No Support"));
    }

    @Getter
    @AllArgsConstructor
    public enum FileType{
        /**
         * geoJson
         */
        GEOJSON("geojson"),
        /**
         * json
         */
        JSON("json"),
        /**
         * json
         */
        SHP("shp"),
        /**
         * kmz
         */
        KMZ("kmz"),
        /**
         * kml
         */
        KML("kml"),
        ;
        private final String name;
    }
}
