package cc.zhaoac.faith.tool.geotool.convert;

import cc.zhaoac.faith.tool.geotool.utils.GeoUtil;
import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import lombok.extern.slf4j.Slf4j;

/**
 * shp文件解析
 *
 * @author zhaoanchi
 * @version 1.0
 * @since 2023-10-18 09:13
 */
@Slf4j
public class GeoJsonFileParser implements IFileParser {

    @Override
    public String parse(File file) {
        try {
            String geojson = FileUtil.readString(file, StandardCharsets.UTF_8);
            return GeoUtil.geoJsonToWkt(geojson);
        } catch (Exception e) {
            log.warn("geojson文件解析异常", e);
            return null;
        }
    }
}
