package cc.zhaoac.faith.tool.geotool.convert;

import cc.zhaoac.faith.tool.geotool.utils.GeoUtil;
import cn.hutool.core.io.IoUtil;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipFile;
import lombok.extern.slf4j.Slf4j;

/**
 * shp文件解析
 *
 * @author zhaoanchi
 * @version 1.0
 * @since 2023-10-18 09:13
 */
@Slf4j
public class KmlFileParser implements IFileParser {

    @Override
    public String parse(File file) {
        try (ZipFile zip = new ZipFile(file)) {
            if (!file.exists()) {
                return null;
            }
            InputStream in = IoUtil.toStream(file);
            String json = GeoUtil.kmlToGeoJson(in);
            return GeoUtil.geoJsonToWkt(json);
        } catch (Exception e) {
            log.warn("kmz文件解析异常", e);
            return null;
        }
    }
}
