package cc.zhaoac.faith.tool.geotool.convert;

import cc.zhaoac.faith.tool.geotool.utils.GeoUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.extern.slf4j.Slf4j;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

/**
 * shp文件解析
 *
 * @author zhaoanchi
 * @version 1.0
 * @since 2023-10-18 09:13
 */
@Slf4j
public class KmzFileParser implements IFileParser {

    @Override
    public String parse(File file) {
        try (ZipFile zip = new ZipFile(file)) {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            if (!file.exists()) {
                return null;
            }
            List<Geometry> geometries = new ArrayList<>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = URLDecoder.decode(entry.getName(), "UTF-8");
                if (entry.getName().contains("__MACOSX") || entry.getName().contains(".DS_STORE")
                        || !entryName.endsWith(".kml")) {
                    continue;
                }
                InputStream in = zip.getInputStream(entry);
                String json = GeoUtil.kmlToGeoJson(in);
                geometries.add(GeoUtil.wktToGeometry(GeoUtil.geoJsonToWkt(json)));
            }

            if (geometries.size() != 1) {
                GeometryFactory geometryFactory = new GeometryFactory();
                GeometryCollection geometryCollection = geometryFactory.createGeometryCollection(
                        geometries.toArray(new Geometry[]{}));
                return geometryCollection.toString();
            } else {
                return geometries.get(0).toString();
            }
        } catch (Exception e) {
            log.warn("kmz文件解析异常", e);
            return null;
        }
    }
}
