package cc.zhaoac.faith.tool.geotool.convert;

import cc.zhaoac.faith.tool.geotool.exception.GeoException;
import cc.zhaoac.faith.tool.geotool.utils.GeoUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

/**
 * shp文件解析
 *
 * @author zhaoanchi
 * @version 1.0
 * @since 2023-10-18 09:13
 */
@Slf4j
public class ShpFileParser implements IFileParser {

    @Override
    public String parse(File file) {
        try {
            List<Map<String, Object>> result = GeoUtil.shpToWkt(file);
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory( null );
            WKTReader reader = new WKTReader( geometryFactory );
            Geometry[] geometries = result.stream().map(m -> m.get("wkt")).map(String::valueOf)
                    .map(wkt -> {
                        try {
                            return reader.read(wkt);
                        } catch (ParseException e) {
                            throw new GeoException(e.getMessage());
                        }
                    }).toArray(Geometry[]::new);
            GeometryFactory gf = new GeometryFactory();
            GeometryCollection geometryCollection = gf.createGeometryCollection(geometries);
            return geometryCollection.toString();
        } catch (IOException e) {
            log.warn("shp文件解析异常", e);
            return null;
        }
    }
}
