package cc.zhaoac.faith.tool.geotool.enums;

import java.util.HashMap;
import java.util.Map;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * geojson类型
 *
 * @author zhaoanchi
 * @version 1.1.0
 * @since 1.1.0
 */
@Getter
@AllArgsConstructor
public enum GeoJsonType {
    /**
     * Feature
     */
    FEATURE("Feature"),
    /**
     * FeatureCollection
     */
    FEATURE_COLLECTION("FeatureCollection"),
    ;

    private final String name;

    static Map<String, GeoJsonType> NAME_MAP;
    static {
        NAME_MAP = new HashMap<>();
        for (GeoJsonType geoJsonType : values()) {
            NAME_MAP.put(geoJsonType.name, geoJsonType);
        }
    }

    /**
     * huoqv z
     * @param name
     * @return
     */
    public static GeoJsonType getType(String name) {
        return NAME_MAP.get(name);
    }
}
