package cc.zhaoac.faith.tool.geotool.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 地理类型
 *
 * @author zhaoanchi
 * @version 1.1.0
 * @since 1.1.0
 */
@Getter
@AllArgsConstructor
public enum GeometryType {
    /**
     * Point
     */
    POINT("Point"),
    /**
     * LineString
     */
    LINESTRING("LineString"),
    /**
     * Polygon
     */
    POLYGON("Polygon"),
    /**
     * MultiPoint
     */
    MULTIPOINT("MultiPoint"),
    /**
     * MultiLineString
     */
    MULTILINESTRING("MultiLineString"),
    /**
     * MultiPolygon
     */
    MULTIPOLYGON("MultiPolygon"),
    /**
     * GeometryCollection
     */
    GEOMETRYCOLLECTION("GeometryCollection"),
    ;

    private final String name;
}
