/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.core.CoreExecutor:20190104164249
 *
 * CoreExecutor.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.core;

import cc.zuv.lang.StringUtils;
import cc.zuv.utility.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-23 20:03
 * @modify.date     2018-12-23 20:03
 */
@Slf4j
@Component
public class CoreExecutor
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    private DSLContext dsl;

    //-----------------------------------------------------------------------------------------

    //每天执行(凌晨0点)
    @Scheduled(cron="0 0 0 * * ?")
//    @Scheduled(cron="*/6 * * * * ?")  //每6秒
    public void format_print_day()
    {
        newline(8, "日期:" + DateUtils.curdate());
    }

    //每小时执行(0分0秒)
    @Scheduled(cron="0 0 * * * ?")
    public void format_print_hour()
    {
        newline(4, "小时:" + DateUtils.curstamp());
    }

    //-----------------------------------------------------------------------------------------

    /**
     * 清理JobsFire数据记录
     *
     * 每月15日2点2分执行
     */
    @Scheduled(cron = "0 2 2 15 * ?")
    public void exec_task_clean_jobsfire()
    {
        //
        long stamp = System.currentTimeMillis() - DateUtils.MILLIS_PER_DAY * 60; //60天
        String sql = "delete from t_jobs_fire where stamp < %d";
        int cnt = dsl.execute(String.format(sql, stamp));

        //
        String message = String.format("exec_task_clean_jobsfire : %d", cnt);
        newline(2, message);
    }

    /**
     * 清理JobsWork数据记录
     *
     * 延时2分钟,上一次开始执行时间点之40分钟再执行
     *
     * fixedRate  上一次开始执行时间点之后
     * fixedDelay 上一次执行完毕时间点之后
     */
    @Scheduled(initialDelay=1000 * 60 * 2, fixedDelay = 1000 * 60 * 40)
    public void exec_task_clean_jobswork()
    {
        //
        long stamp = System.currentTimeMillis() - DateUtils.MILLIS_PER_DAY * 7; //七天
        String sql = "delete from t_jobs_work where stamp < %d";
        int cnt = dsl.execute(String.format(sql, stamp));

        //
        String message = String.format("exec_task_clean_jobswork : %d", cnt);
        newline(2, message);
    }

    //-----------------------------------------------------------------------------------------

    private void newline(int n, String content)
    {
        for(int i=0;i<n;i++)
        {
            System.out.println();
        }

        if(StringUtils.NotEmpty(content))
        {
            System.out.println("-----------------------------------------------------");
            System.out.println(content);
            System.out.println("-----------------------------------------------------");
        }

        for(int i=0;i<n;i++)
        {
            System.out.println();
        }
    }

    //-----------------------------------------------------------------------------------------

}
