/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.quartz.QuartzJobListener:20190104164250
 *
 * QuartzJobListener.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.quartz;

import cc.zuv.job.support.IJobCode;
import cc.zuv.job.support.data.dao.JobsTaskEntityRepository;
import cc.zuv.job.support.data.domain.JobsTaskEntity;
import cc.zuv.job.support.data.enums.TaskStatus;
import lombok.extern.slf4j.Slf4j;
import org.quartz.*;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-25 11:36
 * @modify.date     2018-12-25 11:36
 */
@Slf4j
public class QuartzJobListener implements JobListener,IJobCode
{

    //-----------------------------------------------------------------------------------------

    private JobsTaskEntityRepository jobsTaskEntityRepository;

    public void setJobsTaskEntityRepository(JobsTaskEntityRepository jobsTaskEntityRepository)
    {
        this.jobsTaskEntityRepository = jobsTaskEntityRepository;
    }

    //-----------------------------------------------------------------------------------------

    @Override
    public String getName()
    {
        return "QuartzJobListener";
    }

    //-----------------------------------------------------------------------------------------

    //执行前
    @Override
    public void jobToBeExecuted(JobExecutionContext context)
    {
        JobDetail jobDetail = context.getJobDetail();
        log.debug("jobToBeExecuted {} {}", jobDetail.getKey().toString(), jobDetail.getJobClass());

        //
        JobDataMap datamap = jobDetail.getJobDataMap();
        //
        if(datamap.containsKey(JOBS_MAPDATA_NAME_TASKID) && datamap.getLong(JOBS_MAPDATA_NAME_TASKID)>0)
        {
            Long id = datamap.getLong(JOBS_MAPDATA_NAME_TASKID);
            JobsTaskEntity locate = jobsTaskEntityRepository.findOne(id);
            if(locate!=null)
            {
                //修改状态
                Long execTotalNum = locate.getExecTotalNum();
                locate.setExecTotalNum(execTotalNum==null?1:(execTotalNum + 1));
                locate.setStatus(TaskStatus.RUNNING);
                locate.setLastBeginTime(System.currentTimeMillis());
                jobsTaskEntityRepository.save(locate);
                log.debug("/jobToBeExecuted, result: {}", locate.getId());
            }
        }
    }

    //执行被否决
    @Override
    public void jobExecutionVetoed(JobExecutionContext context)
    {
        JobDetail jobDetail = context.getJobDetail();
        log.debug("jobExecutionVetoed {} {}", jobDetail.getKey().toString(), jobDetail.getJobClass());

        //
        JobDataMap datamap = jobDetail.getJobDataMap();
        //
        if(datamap.containsKey(JOBS_MAPDATA_NAME_TASKID) && datamap.getLong(JOBS_MAPDATA_NAME_TASKID)>0)
        {
            Long id = datamap.getLong(JOBS_MAPDATA_NAME_TASKID);
            JobsTaskEntity locate = jobsTaskEntityRepository.findOne(id);
            if(locate!=null)
            {
                //修改状态
                Long execFailureNum = locate.getExecFailureNum();
                locate.setExecFailureNum(execFailureNum==null?1:(execFailureNum+1));
                locate.setStatus(TaskStatus.INITED);
                locate.setLastEndTime(System.currentTimeMillis());
                locate.setLastMessage("jobExecutionVetoed");
                jobsTaskEntityRepository.save(locate);
                log.debug("/jobExecutionVetoed, result: {}", locate.getId());
            }
        }
    }

    //执行后
    @Override
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException e)
    {
        JobDetail jobDetail = context.getJobDetail();
        log.debug("jobWasExecuted {} {} {}", jobDetail.getKey().toString(), jobDetail.getJobClass(), e);

        //
        JobDataMap datamap = jobDetail.getJobDataMap();
        //
        if(datamap.containsKey(JOBS_MAPDATA_NAME_TASKID) && datamap.getLong(JOBS_MAPDATA_NAME_TASKID)>0)
        {
            Long id = datamap.getLong(JOBS_MAPDATA_NAME_TASKID);
            JobsTaskEntity locate = jobsTaskEntityRepository.findOne(id);
            if(locate!=null)
            {
                //修改状态
                if(e!=null)
                {
                    Long execFailureNum = locate.getExecFailureNum();
                    locate.setExecFailureNum(execFailureNum==null?1:execFailureNum+1);
                    locate.setStatus(TaskStatus.ERROR);
                    locate.setLastMessage(e.getMessage());
                }
                else
                {
                    Long execSuccessNum = locate.getExecSuccessNum();
                    locate.setExecSuccessNum(execSuccessNum==null?1:(execSuccessNum+1));
                    locate.setStatus(TaskStatus.INITED);
                    locate.setLastMessage("jobWasExecuted");
                }
                locate.setLastEndTime(System.currentTimeMillis());
                jobsTaskEntityRepository.save(locate);
                log.debug("/jobWasExecuted, result: {}", locate.getId());
            }
        }
    }

    //-----------------------------------------------------------------------------------------

}
