/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.quartz.QuartzTrigger:20190104164250
 *
 * QuartzTrigger.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.quartz;

import cc.zuv.job.support.data.domain.JobsFireEntity;
import cc.zuv.job.support.data.domain.JobsTaskEntity;
import cc.zuv.lang.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.quartz.*;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-25 15:00
 * @modify.date     2018-12-25 15:00
 */
@Slf4j
public class QuartzTrigger
{

    //-----------------------------------------------------------------------------------------




    //-----------------------------------------------------------------------------------------

    public static TriggerKey bldTriggerKey(JobsTaskEntity task)
    {
        String triggerName = task.getTriggerName();
        String triggerTeam = task.getTriggerTeam();
        return TriggerKey.triggerKey(triggerName, triggerTeam);
    }
    public static TriggerKey bldTriggerKey(JobsFireEntity fire)
    {
        String triggerName = fire.getTriggerName();
        String triggerTeam = fire.getTriggerTeam();
        return TriggerKey.triggerKey(triggerName, triggerTeam);
    }

    //-----------------------------------------------------------------------------------------

    public static CronTrigger bldCronTrigger(JobsTaskEntity task)
    {
        String cron = task.getCron();
        TriggerKey triggerKey = bldTriggerKey(task);
        String desc = task.getMemo();
        return bldCronTrigger(triggerKey, cron, desc);
    }

    //-----------------------------------------------------------------------------------------

    public static CalendarIntervalTrigger bldMonthTrigger(JobsTaskEntity task, int interval)
    {
        CalendarIntervalScheduleBuilder builder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule() //使用CalendarIntervalTrigger
            .withIntervalInMonths(interval); //每interval月执行一次

        return bldCalendarTrigger(task, builder);
    }

    public static CalendarIntervalTrigger bldWeekTrigger(JobsTaskEntity task, int interval)
    {
        CalendarIntervalScheduleBuilder builder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule() //使用CalendarIntervalTrigger
            .withIntervalInWeeks(interval); //每interval天执行一次

        return bldCalendarTrigger(task, builder);
    }

    public static CalendarIntervalTrigger bldDayTrigger(JobsTaskEntity task, int interval)
    {
        CalendarIntervalScheduleBuilder builder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule() //使用CalendarIntervalTrigger
            .withIntervalInDays(interval); //每interval天执行一次

        return bldCalendarTrigger(task, builder);
    }

    public static SimpleTrigger bldHourTrigger(JobsTaskEntity task, int interval, int repeat)
    {
        SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule() //使用SimpleTrigger
            .withIntervalInHours(interval); //每interval小时执行一次

        if(repeat>=0)
            builder.withRepeatCount(repeat);
        else
            builder.repeatForever();

        return bldSimpleTrigger(task, builder);
    }

    public static SimpleTrigger bldMinuteTrigger(JobsTaskEntity task, int interval, int repeat)
    {
        SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule() //使用SimpleTrigger
            .withIntervalInMinutes(interval); //每interval分执行一次

        if(repeat>=0)
            builder.withRepeatCount(repeat);
        else
            builder.repeatForever();

        return bldSimpleTrigger(task, builder);
    }

    public static SimpleTrigger bldSecondTrigger(JobsTaskEntity task, int interval, int repeat)
    {
        SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule() //使用SimpleTrigger
            .withIntervalInSeconds(interval); //每interval秒执行一次

        if(repeat>=0)
            builder.withRepeatCount(repeat);
        else
            builder.repeatForever();

        return bldSimpleTrigger(task, builder);
    }
    public static SimpleTrigger bldMillisecondTrigger(JobsTaskEntity task, int interval, int repeat)
    {
        SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule() //使用SimpleTrigger
            .withIntervalInMilliseconds(interval); //每interval微秒执行一次

        if(repeat>=0)
            builder.withRepeatCount(repeat);
        else
            builder.repeatForever();

        return bldSimpleTrigger(task, builder);
    }

    //-----------------------------------------------------------------------------------------

    public static SimpleTrigger bldSecondTrigger(JobsFireEntity fire, int interval, int repeat)
    {
        SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule() //使用SimpleTrigger
            .withIntervalInSeconds(interval); //每interval秒执行一次

        if(repeat>=0)
            builder.withRepeatCount(repeat);
        else
            builder.repeatForever();

        return bldSimpleTrigger(fire, builder);
    }

    public static SimpleTrigger bldMinuteTrigger(JobsFireEntity fire, int interval, int repeat)
    {
        SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule() //使用SimpleTrigger
            .withIntervalInMinutes(interval); //每interval分执行一次

        if(repeat>=0)
            builder.withRepeatCount(repeat);
        else
            builder.repeatForever();

        return bldSimpleTrigger(fire, builder);
    }

    //-----------------------------------------------------------------------------------------

    public static DailyTimeIntervalTrigger bldMonthTrigger(JobsTaskEntity task)
    {
        DailyTimeIntervalScheduleBuilder builder = DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule(); //使用DailyTimeIntervalTrigger

        builder
            .startingDailyAt(TimeOfDay.hourAndMinuteOfDay(9, 0)) //9：00开始
            .endingDailyAt(TimeOfDay.hourAndMinuteOfDay(16, 0)) //16：00 结束
            .onDaysOfTheWeek(DateBuilder.MONDAY, DateBuilder.TUESDAY, DateBuilder.WEDNESDAY, DateBuilder.THURSDAY,DateBuilder.FRIDAY) //周一至周五执行
            .withIntervalInHours(1) //每间隔1小时执行一次
            .withRepeatCount(100) //最多重复100次（实际执行100+1次）
            .build();

        builder
            .startingDailyAt(TimeOfDay.hourAndMinuteOfDay(9, 0)) //9：00开始
            .endingDailyAfterCount(10) //每天执行10次，这个方法实际上根据 startTimeOfDay+interval*count 算出 endTimeOfDay
            .onDaysOfTheWeek(DateBuilder.MONDAY, DateBuilder.TUESDAY, DateBuilder.WEDNESDAY, DateBuilder.THURSDAY,DateBuilder.FRIDAY) //周一至周五执行
            .withIntervalInHours(1) //每间隔1小时执行一次
            .build();

        return bldDailyTimeTrigger(task, builder);
    }

    //-----------------------------------------------------------------------------------------

    //SimpleTrigger
    public static SimpleTrigger bldSimpleTrigger(JobsTaskEntity task, SimpleScheduleBuilder scheduleBuilder)
    {
        TriggerKey triggerKey = bldTriggerKey(task);
        String desc = task.getMemo();
        String calname = task.getCalname();
        return bldSimpleTrigger(triggerKey, desc, calname, scheduleBuilder);
    }
    //SimpleTrigger
    public static SimpleTrigger bldSimpleTrigger(JobsFireEntity fire, SimpleScheduleBuilder scheduleBuilder)
    {
        TriggerKey triggerKey = bldTriggerKey(fire);
        String desc = fire.getMemo();
        return bldSimpleTrigger(triggerKey, desc, null, scheduleBuilder);
    }
    //CalendarIntervalTrigger
    public static CalendarIntervalTrigger bldCalendarTrigger(JobsTaskEntity task, CalendarIntervalScheduleBuilder scheduleBuilder)
    {
        TriggerKey triggerKey = bldTriggerKey(task);
        String desc = task.getMemo();
        String calname = task.getCalname();
        return bldCalendarTrigger(triggerKey, desc, calname, scheduleBuilder);
    }
    //DailyTimeIntervalTrigger
    public static DailyTimeIntervalTrigger bldDailyTimeTrigger(JobsTaskEntity task, DailyTimeIntervalScheduleBuilder scheduleBuilder)
    {
        TriggerKey triggerKey = bldTriggerKey(task);
        String desc = task.getMemo();
        String calname = task.getCalname();
        return bldDailyTimeTrigger(triggerKey, desc, calname, scheduleBuilder);
    }

    //-----------------------------------------------------------------------------------------

    //CronTrigger
    public static CronTrigger bldCronTrigger(TriggerKey triggerKey, String cron, String desc)
    {
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule(cron)
            .withMisfireHandlingInstructionDoNothing();

        return TriggerBuilder.newTrigger()
            .withIdentity(triggerKey)
            .withDescription(desc)
            .withSchedule(cronScheduleBuilder)
//            .startNow()
            .build();
    }

    //SimpleTrigger
    public static SimpleTrigger bldSimpleTrigger(TriggerKey triggerKey, String desc, String calname, SimpleScheduleBuilder scheduleBuilder)
    {
        TriggerBuilder<SimpleTrigger> builder = TriggerBuilder.newTrigger()
            .withIdentity(triggerKey)
            .withDescription(desc)
//            .startNow()
            .withSchedule(scheduleBuilder);

        if(StringUtils.NotEmpty(calname)) builder.modifiedByCalendar(calname);
        return builder.build();
    }

    //CalendarIntervalTrigger
    public static CalendarIntervalTrigger bldCalendarTrigger(TriggerKey triggerKey, String desc, String calname, CalendarIntervalScheduleBuilder scheduleBuilder)
    {
        TriggerBuilder<CalendarIntervalTrigger> builder = TriggerBuilder.newTrigger()
            .withIdentity(triggerKey)
            .withDescription(desc)
//            .startNow()
            .withSchedule(scheduleBuilder);

        if(StringUtils.NotEmpty(calname)) builder.modifiedByCalendar(calname);
        return builder.build();
    }

    //DailyTimeIntervalTrigger
    public static DailyTimeIntervalTrigger bldDailyTimeTrigger(TriggerKey triggerKey, String desc, String calname, DailyTimeIntervalScheduleBuilder scheduleBuilder)
    {
        TriggerBuilder<DailyTimeIntervalTrigger> builder = TriggerBuilder.newTrigger()
            .withIdentity(triggerKey)
            .withDescription(desc)
//            .startNow()
            .withSchedule(scheduleBuilder);

        if(StringUtils.NotEmpty(calname)) builder.modifiedByCalendar(calname);
        return builder.build();
    }

    //-----------------------------------------------------------------------------------------

}
