/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.quartz.executor.QuartzEventExecutor:20190104164249
 *
 * QuartzEventExecutor.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.quartz.executor;

import cc.zuv.job.support.IJobCode;
import cc.zuv.job.support.core.IExecContext;
import cc.zuv.job.support.core.IExecutor;
import cc.zuv.job.support.data.dao.JobsFireEntityRepository;
import cc.zuv.job.support.data.domain.JobsFireEntity;
import cc.zuv.job.support.data.enums.TaskStatus;
import lombok.extern.slf4j.Slf4j;
import org.quartz.*;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 事件触发操作,允许并发
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-24 17:26
 * @modify.date     2018-12-24 17:26
 */
@Slf4j
@PersistJobDataAfterExecution
public abstract class QuartzEventExecutor implements IExecutor, IJobCode, Job
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    protected JobsFireEntityRepository jobsFireEntityRepository;

    //-----------------------------------------------------------------------------------------

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException
    {
        //
        JobDetail detail = context.getJobDetail();
        if(detail.getJobDataMap()==null
            || !detail.getJobDataMap().containsKey(JOBS_MAPDATA_NAME_FIREID)) return;

        //
        String key = detail.getKey().getName() + " @ " + detail.getKey().getGroup();
        String desc = detail.getDescription();
        Long fireid = detail.getJobDataMap().getLong(JOBS_MAPDATA_NAME_FIREID);
        String firereqcode = detail.getJobDataMap().getString(JOBS_MAPDATA_NAME_FIREREQCODE);
        String firereqdata = detail.getJobDataMap().getString(JOBS_MAPDATA_NAME_FIREREQDATA);
        log.debug("{} ({}) : {} {} {}", key, desc, fireid, firereqcode, firereqdata);

        //
        JobsFireEntity entity = jobsFireEntityRepository.findOne(fireid);
        if(entity==null)
        {
            log.error("JobsFireEntity(id={}) not found.", fireid);
            return;
        }
        entity.setStatus(TaskStatus.RUNNING);
        entity.setBeginTime(System.currentTimeMillis());
        entity = jobsFireEntityRepository.save(entity);

        try
        {
            //修改resdata, endtime, status
            execute(new QuartzExecContext(detail));
        }
        catch (Exception e)
        {
            //
            entity.setStatus(TaskStatus.ERROR);
            entity.setEndTime(System.currentTimeMillis());
            entity.setMessage(e.getMessage());
            jobsFireEntityRepository.save(entity);

//            // 策略1: 修复错误并立即重新启动
//            JobExecutionException e2 = new JobExecutionException(e);
//            detail.getJobDataMap().put("fixed", true);
//            e2.setRefireImmediately(true);

            // 策略2: 自动取消与此作业相关联的所有触发器, 以使其不再运行
            JobExecutionException e2 = new JobExecutionException(e);
            e2.setUnscheduleFiringTrigger(true);
//            e2.setUnscheduleAllTriggers(true);

            throw e2;
        }
    }


    public abstract void execute(IExecContext context);

    //-----------------------------------------------------------------------------------------


}
