/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.quartz.executor.QuartzExecContext:20190104164249
 *
 * QuartzExecContext.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.quartz.executor;

import cc.zuv.job.support.core.IExecContext;
import org.quartz.JobDetail;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-24 18:04
 * @modify.date     2018-12-24 18:04
 */
public class QuartzExecContext implements IExecContext
{

    //-----------------------------------------------------------------------------------------

    private JobDetail jobdetail;

    //-----------------------------------------------------------------------------------------

    public QuartzExecContext(JobDetail jobdetail)
    {
        this.jobdetail = jobdetail;
    }

    //-----------------------------------------------------------------------------------------

    @Override
    public String getKey()
    {
        return jobdetail.getKey().getName() + " @ " + jobdetail.getKey().getGroup();
    }

    @Override
    public String getDescription()
    {
        return jobdetail.getDescription();
    }

    @Override
    public Object getDataVal(String key)
    {
        return jobdetail.getJobDataMap().get(key);
    }

    @Override
    public String getDataValString(String key)
    {
        return jobdetail.getJobDataMap().getString(key);
    }

    @Override
    public Integer getDataValInteger(String key)
    {
        return jobdetail.getJobDataMap().getInt(key);
    }

    @Override
    public Boolean getDataValBoolean(String key)
    {
        return jobdetail.getJobDataMap().getBoolean(key);
    }

    @Override
    public Long getDataValLong(String key)
    {
        return jobdetail.getJobDataMap().getLong(key);
    }

    //-----------------------------------------------------------------------------------------


}
