/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.quartz.QuartzCalendar:20190104164250
 *
 * QuartzCalendar.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.quartz;

import org.quartz.DateBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.calendar.AnnualCalendar;

import java.util.GregorianCalendar;


/**
 * 配合Trigger,补充包含或排除一些时间点
 *
 *
 * 所有的Calendar既可以是排除，也可以是包含，取决于：

 HolidayCalendar。指定特定的日期，比如20140613。精度到天。
 DailyCalendar。指定每天的时间段（rangeStartingTime, rangeEndingTime)，格式是HH:MM[:SS[:mmm]]。也就是最大精度可以到毫秒。
 WeeklyCalendar。指定每星期的星期几，可选值比如为java.util.Calendar.SUNDAY。精度是天。
 MonthlyCalendar。指定每月的几号。可选值为1-31。精度是天
 AnnualCalendar。 指定每年的哪一天。使用方式如上例。精度是天。
 CronCalendar。指定Cron表达式。精度取决于Cron表达式，也就是最大精度可以到秒。
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-25 16:19
 * @modify.date     2018-12-25 16:19
 */
public class QuartzCalendar
{

    //-----------------------------------------------------------------------------------------

    //年,指定年的哪一天,精度是天
    public static void addAnnualCalendar(Scheduler scheduler, String name, int month, int day) throws SchedulerException
    {
        AnnualCalendar cal = new AnnualCalendar(); //定义一个每年执行Calendar，精度为天，即不能定义到2.25号下午2:00
        java.util.Calendar excludeDay = new GregorianCalendar();
        excludeDay.setTime(DateBuilder.newDate().inMonthOnDay(month, day).build());
        cal.setDayExcluded(excludeDay, true);  //设置排除2.25这个日期
        scheduler.addCalendar(name, cal, false, false); //scheduler加入这个Calendar
    }

    //-----------------------------------------------------------------------------------------

}
