/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.quartz.executor.QuartzScanExecutor:20190104164249
 *
 * QuartzScanExecutor.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.quartz.executor;

import cc.zuv.job.support.IJobCode;
import cc.zuv.job.support.core.IExecContext;
import cc.zuv.job.support.core.IExecutor;
import cc.zuv.job.support.data.dao.JobsWorkEntityRepository;
import cc.zuv.job.support.data.domain.JobsWorkEntity;
import cc.zuv.job.support.data.enums.TaskStatus;
import lombok.extern.slf4j.Slf4j;
import org.quartz.*;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 任务扫描操作,不允许并发
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-24 17:26
 * @modify.date     2018-12-24 17:26
 */
@Slf4j
@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public abstract class QuartzScanExecutor implements IExecutor, IJobCode, Job
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    protected JobsWorkEntityRepository jobsWorkEntityRepository;

    //-----------------------------------------------------------------------------------------

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException
    {
        //
        JobDetail detail = context.getJobDetail();
        if(detail.getJobDataMap()==null
            || !detail.getJobDataMap().containsKey(JOBS_MAPDATA_NAME_TASKID)) return;

        //
        String key = detail.getKey().getName() + " @ " + detail.getKey().getGroup();
        String desc = detail.getDescription();
        Long taskid = detail.getJobDataMap().getLong(JOBS_MAPDATA_NAME_TASKID);
        String taskdata = detail.getJobDataMap().getString(JOBS_MAPDATA_NAME_TASKDATA);
        log.debug("{} ({}) : {} {}", key, desc, taskid, taskdata);

        //
        JobsWorkEntity entity = new JobsWorkEntity();
        entity.setTaskid(taskid);
        entity.setData(taskdata);
        entity.setStatus(TaskStatus.RUNNING);
        entity.setBeginTime(System.currentTimeMillis());
        entity = jobsWorkEntityRepository.save(entity);

        try
        {
            //修改startid, endid, effectnum, status, endtime, snapshot
            detail.getJobDataMap().put(JOBS_MAPDATA_NAME_WORKID, entity.getId());
            execute(new QuartzExecContext(detail));
        }
        catch (Exception e)
        {
            //
            entity.setStatus(TaskStatus.ERROR);
            entity.setEndTime(System.currentTimeMillis());
            entity.setMessage(e.getMessage());
            jobsWorkEntityRepository.save(entity);

//            // 策略1: 修复错误并立即重新启动
//            JobExecutionException e2 = new JobExecutionException(e);
//            detail.getJobDataMap().put("fixed", true);
//            e2.setRefireImmediately(true);

            // 策略2: 自动取消与此作业相关联的所有触发器, 以使其不再运行
            JobExecutionException e2 = new JobExecutionException(e);
            e2.setUnscheduleFiringTrigger(true);
//            e2.setUnscheduleAllTriggers(true);
            throw e2;
        }
    }

    public abstract void execute(IExecContext context);

    //-----------------------------------------------------------------------------------------


}
