/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.data.dao.JobsFireEntityRepository:20190104164249
 *
 * JobsFireEntityRepository.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.data.dao;

import cc.zuv.dbs.provider.jpa.DataRepository;
import cc.zuv.job.support.data.domain.JobsFireEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-02 15:20
 * @modify.date     2018-12-02 15:20
 */
public interface JobsFireEntityRepository extends DataRepository<JobsFireEntity, Long>
{

    //-----------------------------------------------------------------------------------------

    JobsFireEntity findFirstByValidTrueOrderByIdDesc();
    List<JobsFireEntity> findByValidTrue();
    Page<JobsFireEntity> findByValidTrue(Pageable pageable);

    @Modifying
    @Query("update JobsFireEntity t set t.valid = ?1 where t.id = ?2")
    int updateValidById(Boolean valid, Long id);

    //-----------------------------------------------------------------------------------------

    List<JobsFireEntity> findByValidTrueAndReqcodeOrderByIdDesc(String reqcode);
    Page<JobsFireEntity> findByValidTrueAndReqcodeOrderByIdDesc(String reqcode, Pageable pageable);

    //-----------------------------------------------------------------------------------------

    int deleteById(Long id);

    //-----------------------------------------------------------------------------------------

}
