/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.quartz.demo.DemoEventExecutor:20190104164249
 *
 * DemoEventExecutor.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.quartz.demo;

import cc.zuv.job.support.core.IExecContext;
import cc.zuv.job.support.data.domain.JobsFireEntity;
import cc.zuv.job.support.data.enums.TaskStatus;
import cc.zuv.job.support.impl.quartz.executor.QuartzEventExecutor;
import lombok.extern.slf4j.Slf4j;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-23 20:12
 * @modify.date     2018-12-23 20:12
 */
@Slf4j
public class DemoEventExecutor extends QuartzEventExecutor
{

    //-----------------------------------------------------------------------------------------

    //-----------------------------------------------------------------------------------------

    @Override
    public void execute(IExecContext context)
    {
        //
        String key = context.getKey();
        String desc = context.getDescription();
        Long fireid = context.getDataValLong(JOBS_MAPDATA_NAME_FIREID);
        String firereqcode = context.getDataValString(JOBS_MAPDATA_NAME_FIREREQCODE);
        String firereqdata = context.getDataValString(JOBS_MAPDATA_NAME_FIREREQDATA);
        log.info("{} ({}) : {}  {} {}", key, desc, fireid, firereqcode, firereqdata);

        //
        JobsFireEntity entity = jobsFireEntityRepository.findOne(fireid);
        if(entity==null)
        {
            log.error("JobsFireEntity(id={}) not found.", fireid);
            return;
        }

        entity.setResdata("{result:'ok'}");
        entity.setStatus(TaskStatus.FINISH);
        entity.setEndTime(System.currentTimeMillis());
        jobsFireEntityRepository.save(entity);
    }

    //-----------------------------------------------------------------------------------------

}
