/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.core.CoreExecutor:20190104164249
 *
 * CoreExecutor.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.core;

import cc.zuv.lang.StringUtils;
import cc.zuv.utility.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-23 20:03
 * @modify.date     2018-12-23 20:03
 */
@Slf4j
@Component
public class CoreExecutor
{

    //-----------------------------------------------------------------------------------------

    //每天执行(凌晨0点)
    @Scheduled(cron="0 0 0 * * ?")
//    @Scheduled(cron="*/6 * * * * ?")  //每6秒
    public void format_print_day()
    {
        newline(8, "日期:" + DateUtils.curdate());
    }

    //每小时执行(0分0秒)
    @Scheduled(cron="0 0 * * * ?")
    public void format_print_hour()
    {
        newline(4, "小时:" + DateUtils.curstamp());
    }

    //-----------------------------------------------------------------------------------------



    //-----------------------------------------------------------------------------------------

    protected void newline(int n, String content)
    {
        newlineout(n, content);
        newlinelog(n, content);
    }

    protected void newlineout(int n, String content)
    {
        for(int i=0;i<n;i++)
        {
            System.out.println();
        }

        if(StringUtils.NotEmpty(content))
        {
            System.out.println("-----------------------------------------------------");
            System.out.println("| "+content);
            System.out.println("-----------------------------------------------------");
        }

        for(int i=0;i<n;i++)
        {
            System.out.println();
        }
    }

    protected void newlinelog(int n, String content)
    {
        for(int i=0;i<n;i++)
        {
            log.info("");
        }

        if(StringUtils.NotEmpty(content))
        {
            log.info("-----------------------------------------------------");
            log.info("| "+content);
            log.info("-----------------------------------------------------");
        }

        for(int i=0;i<n;i++)
        {
            log.info("");
        }
    }

    //-----------------------------------------------------------------------------------------

}
