/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.data.dao.JobsTaskEntityRepository:20190104164249
 *
 * JobsTaskEntityRepository.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.data.dao;

import cc.zuv.dbs.provider.jpa.DataRepository;
import cc.zuv.job.support.data.domain.JobsTaskEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-02 15:20
 * @modify.date     2018-12-02 15:20
 */
public interface JobsTaskEntityRepository extends DataRepository<JobsTaskEntity, Long>
{

    //-----------------------------------------------------------------------------------------

    JobsTaskEntity findFirstByValidTrueOrderByIdDesc();
    List<JobsTaskEntity> findByValidTrue();
    Page<JobsTaskEntity> findByValidTrue(Pageable pageable);

    @Modifying
    @Query("update JobsTaskEntity t set t.valid = ?1 where t.id = ?2")
    int updateValidById(Boolean valid, Long id);

    //-----------------------------------------------------------------------------------------

    JobsTaskEntity findFirstByValidTrueAndNameAndTeamOrderByIdDesc(String name, String team);
    JobsTaskEntity findFirstByNameAndTeamOrderByIdDesc(String name, String team);

    //-----------------------------------------------------------------------------------------

    int countByValidTrueAndNameAndTeam(String name, String team);

    int countByNameAndTeam(String name, String team);

    //-----------------------------------------------------------------------------------------

    int deleteById(Long id);

    //-----------------------------------------------------------------------------------------

}
