/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.data.domain.JobsTaskEntity:20190104164249
 *
 * JobsTaskEntity.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.data.domain;

import cc.zuv.dbs.entity.AbstractEntity;
import cc.zuv.job.support.IJobCode;
import cc.zuv.job.support.data.enums.TaskStatus;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 任务定义
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-02 15:20
 * @modify.date     2018-12-02 15:20
 */
@Entity
@Table(name = "t_jobs_task")
@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class JobsTaskEntity extends AbstractEntity implements Serializable, IJobCode
{

    //-----------------------------------------------------------------------------------------

    private static final long serialVersionUID = -4363574273596384979L;

    //-----------------------------------------------------------------------------------------

    //-----------------------------------------------------------------------------------------

    @Column(nullable = false)
    private String      name;   //任务名称
    private String      team;   //任务群组
    private String      memo;   //任务描述
    private String      cron;   //任务表达式
    private String      data;   //启动数据
//    @Enumerated(EnumType.STRING)
//    @Column(nullable = false, columnDefinition = "VARCHAR(255)")
//    private ITaskType   type;   //类型, 对应执行器类名
    @Column(nullable = false)
    private String      clsname;    //执行器类名
    private TaskStatus  status;     //正在运行,完成停止,错误中断,用户暂停
    private Boolean     restart;    //是否立即启动
    private String      calname;    //日历名称

    //
    private Long    execTotalNum;   //执行总次数
    private Long    execFailureNum; //执行失败次数
    private Long    execSuccessNum; //执行成功次数

    //
    private Long    lastBeginTime;  //最后一次启动时间
    private Long    lastEndTime;    //最后一次结束时间
    @Column(columnDefinition = "VARCHAR(2000)")
    private String  lastSnapshot;   //最后一次快照数据
    @Column(columnDefinition = "VARCHAR(2000)")
    private String  lastMessage;    //最后一次执行信息

    //-----------------------------------------------------------------------------------------

    @Transient
    public String getIdentity()
    {
        return team + "." + name;
    }

    @Transient
    public String getTriggerName() //触发器名称
    {
        return JOBS_TRIGGER_PREFIX + name;
    }

    @Transient
    public String getTriggerTeam() //触发器群组
    {
        return team;
    }

    //-----------------------------------------------------------------------------------------

}
