/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.data.dao.JobsWorkEntityRepository:20190104164249
 *
 * JobsWorkEntityRepository.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.data.dao;

import cc.zuv.dbs.provider.jpa.DataRepository;
import cc.zuv.job.support.data.domain.JobsWorkEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-02 15:20
 * @modify.date     2018-12-02 15:20
 */
public interface JobsWorkEntityRepository extends DataRepository<JobsWorkEntity, Long>
{

    //-----------------------------------------------------------------------------------------

    JobsWorkEntity findFirstByValidTrueOrderByIdDesc();
    List<JobsWorkEntity> findByValidTrue();
    Page<JobsWorkEntity> findByValidTrue(Pageable pageable);

    @Modifying
    @Query("update JobsWorkEntity t set t.valid = ?1 where t.id = ?2")
    int updateValidById(Boolean valid, Long id);

    //-----------------------------------------------------------------------------------------

    Page<JobsWorkEntity> findByValidTrueAndTaskidOrderByIdDesc(Long taskid, Pageable pageable);

    //-----------------------------------------------------------------------------------------

    int deleteById(Long id);

    //-----------------------------------------------------------------------------------------

}
