/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.data.domain.Domain:20190104164249
 *
 * Domain.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.data.domain;

import cc.zuv.dbs.entity.AbstractEntity;
import lombok.*;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;

/**
 * 测试实体
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-02 15:20
 * @modify.date     2018-12-02 15:20
 */
@Entity
@Table(name = "t_jobs_domain")
@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class Domain extends AbstractEntity implements Serializable
{

    //-----------------------------------------------------------------------------------------

    private static final long serialVersionUID = -4363574273596384979L;

    //-----------------------------------------------------------------------------------------

    @Column(nullable = false, unique = true)
    private String code;

    private String name;

    private Integer type;

    //-----------------------------------------------------------------------------------------

    @Transient
    public String getCredentialsSalt()
    {
        return type + code;
    }

    //-----------------------------------------------------------------------------------------

}
