/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.data.domain.JobsWorkEntity:20190104164249
 *
 * JobsWorkEntity.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.data.domain;

import cc.zuv.dbs.entity.AbstractEntity;
import cc.zuv.job.support.data.enums.TaskStatus;
import lombok.*;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 定时任务执行情况
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-02 15:20
 * @modify.date     2018-12-02 15:20
 */
@Entity
@Table(name = "t_jobs_work")
@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class JobsWorkEntity extends AbstractEntity implements Serializable
{

    //-----------------------------------------------------------------------------------------

    private static final long serialVersionUID = -4363574273596384979L;

    //-----------------------------------------------------------------------------------------

    private Long        taskid;     //任务ID
    private String      data;       //启动数据
    @Enumerated(EnumType.STRING)
    private TaskStatus  status;     //正在运行,完成停止,错误中断,用户暂停
    private String      snapshot;   //快照数据
    private String      message;    //运行信息

    private Long    beginTime;  //开始时间
    private Long    endTime;    //结束时间
    private Long    beginId;    //记录起点
    private Long    endId;      //记录终点
    private Long    effectNum;  //影响数目

    //-----------------------------------------------------------------------------------------

    //-----------------------------------------------------------------------------------------

}
