/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.data.domain.JobsFireEntity:20190104164249
 *
 * JobsFireEntity.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.data.domain;

import cc.zuv.dbs.entity.AbstractEntity;
import cc.zuv.job.support.IJobCode;
import cc.zuv.job.support.data.enums.TaskStatus;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 触发任务执行情况
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-02 15:20
 * @modify.date     2018-12-02 15:20
 */
@Entity
@Table(name = "t_jobs_fire")
@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class JobsFireEntity extends AbstractEntity implements Serializable, IJobCode
{

    //-----------------------------------------------------------------------------------------

    private static final long serialVersionUID = 3610257513266029151L;

    //-----------------------------------------------------------------------------------------

    @Column(nullable = false)
    private String  name;   //任务名称
    private String  team;   //任务群组
    private String  memo;   //任务描述
    @Column(nullable = false)
    private String  clsname;    //执行器类名
    @Column(columnDefinition = "TEXT")
    private String  message;    //运行信息
    @Enumerated(EnumType.STRING)
    private TaskStatus status;  //正在运行,完成停止,错误中断,用户暂停


    private String  reqcode;    //请求标识
    @Column(columnDefinition = "TEXT")
    private String  reqdata;    //请求数据
    private String  rescode;    //响应标识
    @Column(columnDefinition = "TEXT")
    private String  resdata;    //响应数据
    private String  cbapiurl;   //回调URL
    @Column(columnDefinition = "TEXT")
    private String  cbresult;   //回调结果
    private Boolean cbexeced;   //回调执行否
    private Long    beginTime;  //开始时间
    private Long    endTime;    //结束时间

    //-----------------------------------------------------------------------------------------

    @Transient
    public String getIdentity()
    {
        return getTeam() + "." + getName();
    }

    @Transient
    public String getTriggerName() //触发器名称
    {
        return JOBS_TRIGGER_PREFIX + getName();
    }

    @Transient
    public String getTriggerTeam() //触发器群组
    {
        return getName();
    }

    //-----------------------------------------------------------------------------------------

}
