/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.executor.CleanExecutor:20190326143938
 *
 * CleanExecutor.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.executor;

import cc.zuv.job.support.core.CoreExecutor;
import cc.zuv.utility.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-03-26 14:39
 * @modify.date     2019-03-26 14:39
 */
@Slf4j
@Component
public class CleanExecutor extends CoreExecutor
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    protected DSLContext dsl;

    //-----------------------------------------------------------------------------------------


    /**
     * 清理JobsFire数据记录
     *
     * 每月15日2点2分执行
     */
    @Scheduled(cron = "0 2 2 15 * ?")
    public void exec_task_clean_jobsfire()
    {
        //
        long stamp = System.currentTimeMillis() - DateUtils.MILLIS_PER_DAY * 120; //120天
        String sql = "delete from t_jobs_fire where stamp < %d";
        int cnt = dsl.execute(String.format(sql, stamp));

        //
        String message = String.format("exec_task_clean_jobsfire : %d", cnt);
        newline(2, message);
    }

    /**
     * 清理JobsWork数据记录
     *
     * 延时2分钟,上一次开始执行时间点之40分钟再执行
     *
     * fixedRate  上一次开始执行时间点之后
     * fixedDelay 上一次执行完毕时间点之后
     */
    @Scheduled(initialDelay=1000 * 60 * 2, fixedDelay = 1000 * 60 * 40)
    public void exec_task_clean_jobswork()
    {
        //
        long stamp = System.currentTimeMillis() - DateUtils.MILLIS_PER_DAY * 24; //24天
        String sql = "delete from t_jobs_work where stamp < %d";
        int cnt = dsl.execute(String.format(sql, stamp));

        //
        String message = String.format("exec_task_clean_jobswork : %d", cnt);
        newline(2, message);
    }

    //-----------------------------------------------------------------------------------------

}
