/*
 * Id$: zuv-cloud:z-job-support:cc.zuv.job.support.impl.quartz.demo.DemoScanExecutor:20190104164249
 *
 * DemoScanExecutor.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.job.support.impl.quartz.demo;

import cc.zuv.ZuvException;
import cc.zuv.job.support.core.IExecContext;
import cc.zuv.job.support.data.domain.JobsTaskEntity;
import cc.zuv.job.support.impl.quartz.executor.QuartzScanExecutor;
import lombok.extern.slf4j.Slf4j;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-24 17:59
 * @modify.date     2018-12-24 17:59
 */
@Slf4j
public class DemoScanExecutor extends QuartzScanExecutor
{

    //-----------------------------------------------------------------------------------------

    @Override
    public void execute(IExecContext context) throws ZuvException
    {
        //-----------------------------------------------------------------------------------------

        begin();

        //-----------------------------------------------------------------------------------------

        //
        String key = context.getKey();
        String desc = context.getDescription();
        Long taskid = context.getDataValLong(JOBS_MAPDATA_NAME_TASKID);
        log.info("{} ({}) : {}", key, desc, taskid);

        JobsTaskEntity taskEntity = jobTaskEntityRepository.findOne(taskid);
        String taskdata = taskEntity.getData();
        Boolean taskrecord = taskEntity.getRecord();
        log.info("{} {}", taskdata, taskrecord);

        //-----------------------------------------------------------------------------------------

        end();

        //-----------------------------------------------------------------------------------------

    }

    //-----------------------------------------------------------------------------------------

}
