/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.storage.MvcLocalFileConfig:20190101180921
 *
 * MvcLocalFileConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.storage;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * File
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
@Configuration
public class MvcLocalFileConfig extends WebMvcConfigurerAdapter
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    private DfsConfig dfsConfig;

    //-----------------------------------------------------------------------------------------

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry)
    {
        if(dfsConfig!=null
            && DfsType.LOCAL == dfsConfig.getType()
            && dfsConfig.getLocal()!=null)
        {
            String mapping = dfsConfig.getLocal().getMapping() + "/**";
            String phypath = "file:" + dfsConfig.getLocal().getPhypath() + "/";
            if(!registry.hasMappingForPattern(mapping))
            {
                log.info("add mapping {} to {}", mapping, phypath);
                registry.addResourceHandler(mapping).addResourceLocations(phypath);
                super.addResourceHandlers(registry);
            }
        }
    }

    //-----------------------------------------------------------------------------------------

}
