/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.utility.WebsPathUtils:20181225110811
 *
 * WebsPathUtils.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.utility;

import cc.zuv.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-18 21:06
 * @modify.date     2018-12-18 21:06
 */
public class WebsPathUtils
{

    //-----------------------------------------------------------------------------------------

    public String getServerUrl(HttpServletRequest request)
    {
        String scheme = request.getScheme();
        String header_scheme = request.getHeader("X-Forwarded-Proto");
        if(StringUtils.NotEmpty(header_scheme) && ("http".equalsIgnoreCase(header_scheme) || "https".equalsIgnoreCase(header_scheme) ))
        {
            scheme = header_scheme;
        }
        return scheme + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    public String getClientIp(HttpServletRequest request)
    {
        String ip = request.getHeader("X-Forwarded-For");
        if(StringUtils.IsEmpty(ip))
        {
            ip = request.getHeader("X-Real-IP");
        }
        if(StringUtils.IsEmpty(ip))
        {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if(StringUtils.IsEmpty(ip))
        {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public String getServletPath(HttpServletRequest request)
    {
        return request.getSession().getServletContext().getRealPath("");
    }

    //-----------------------------------------------------------------------------------------


}
