/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.template.freemarker.SpringFreeMarkerView:20190104105619
 *
 * SpringFreeMarkerView.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.template.freemarker;

import cc.zuv.web.support.template.IWebTplCode;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-04 10:56
 * @modify.date     2019-01-04 10:56
 */
@Component
public class SpringFreeMarkerView extends FreeMarkerView implements IWebTplCode
{

    //-----------------------------------------------------------------------------------------

    @Override
    protected void exposeHelpers(Map<String, Object> model,
                                 HttpServletRequest request) throws Exception
    {
        // content为webapp目录
        // http://zuv.cc:8080/content/manage/user_detail?userid=12

        String urls     = request.getRequestURL().toString();   // http://zuv.cc:8080/content/manage/user_detail
//        String uris     = request.getRequestURI();              // /content/manage/user_detail
//        String path     = request.getServletPath();             // /manage/user_detail
        String para     = request.getQueryString();             // userid=12
        String content  = request.getContextPath();             // /content
        String selfurl  = (para!=null)?(urls+"?"+para):urls;    // http://zuv.cc:8080/content/manage/user_detail?userid=12

        int fixlen = (request.getScheme()+"://").length();
        int endidx = fixlen + urls.substring(fixlen).indexOf("/");
        String lhost     = urls.substring(0, endidx);           // http://zuv.cc:8080

        model.put(TPL_TAG_CONTEXT_HOST, lhost);     //协议+主机+端口
        model.put(TPL_TAG_CONTEXT_PATH, selfurl);   //全路径+参数
        model.put(TPL_TAG_CONTEXT_URLS, urls);      //全路径
        model.put(TPL_TAG_CONTEXT_BASE, content);
        super.exposeHelpers(model, request);
    }

    //-----------------------------------------------------------------------------------------

}
