/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.validator.AssertUtil:20181225110811
 *
 * AssertUtil.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */
package cc.zuv.web.support.validator;

import cc.zuv.web.support.exception.RestBadRequestException;
import cc.zuv.web.support.exception.RestHasExistsException;
import cc.zuv.web.support.exception.RestNotFoundException;
import lombok.extern.slf4j.Slf4j;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
public class AssertUtil
{

    //-----------------------------------------------------------------------------------------

    public static void assertTrue(boolean value, String message)
    {
        if (value)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertBetween(byte min, byte max, byte value, String message)
    {
        if (value<min || value>=max)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertBetween(int min, int max, int value, String message)
    {
        if (value<min || value>=max)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertBlank(String value, String message)
    {
        if (value==null || value.trim().length()==0)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNull(Object value, String message)
    {
        if (value == null)
        {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotFound(Object value, String message)
    {
        if (value == null)
        {
            throw new RestNotFoundException(message);
        }
    }

    public static void assertHasExist(Object value, String message)
    {
        if (value != null)
        {
            throw new RestHasExistsException(message);
        }
    }

    //-----------------------------------------------------------------------------------------

}
