/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.captcha.kaptcha.KaptchaService:20190102095522
 *
 * KaptchaService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.captcha.kaptcha;

import com.google.code.kaptcha.Producer;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.awt.image.BufferedImage;

/**
 * Kaptcha
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
public class KaptchaService
{

    //-----------------------------------------------------------------------------------------

    private Producer producer;

    public KaptchaService(Producer producer)
    {
        this.producer = producer;
    }

    //-----------------------------------------------------------------------------------------

    /*
     * 生成验证码
     */
    public BufferedImage generateCaptcha(HttpServletRequest request)
    {
        //
        HttpSession session = request.getSession(true);
        String sessionid = session.getId();
        String captcha = producer.createText();
        log.debug("generate captcha {} {}", sessionid, captcha);

        //
        session.setAttribute(sessionid, captcha);
        return producer.createImage(captcha);
    }

    /*
     * 验证码校验
     */
    public boolean validateCaptcha(HttpServletRequest request, String captcha)
    {
        HttpSession session = request.getSession();
        String sessionid = session.getId();
        Object value = session.getAttribute(sessionid);
        log.debug("validate captcha {} {} {}", sessionid, captcha, value);

        //
        return (value!=null) && captcha.equalsIgnoreCase((String)value);
    }

    //-----------------------------------------------------------------------------------------

}
