/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.utility.HttpRenderUtils:20190425154634
 *
 * HttpRenderUtils.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.utility;

import cc.zuv.lang.StringUtils;
import cc.zuv.utility.CodecUtils;
import cc.zuv.utility.MimeUtils;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-04-25 11:47
 * @modify.date     2019-04-25 11:47
 */
public class HttpRenderUtils
{

    //-----------------------------------------------------------------------------------------

    public static void render_html(HttpServletResponse response, String html)
        throws IOException
    {
        render_content(response, MimeUtils.FILE_TYPE_HTML, html);
    }

    public static void render_text(HttpServletResponse response, String txt)
        throws IOException
    {
        render_content(response, MimeUtils.FILE_TYPE_TEXT, txt);
    }

    public static void render_xml(HttpServletResponse response, String xml)
        throws IOException
    {
        render_content(response, MimeUtils.FILE_TYPE_XML, xml);
    }

    public static void render_json(HttpServletResponse response, String json)
        throws IOException
    {
        render_content(response, MimeUtils.FILE_TYPE_JSON, json);
    }

    private static void render_content(HttpServletResponse response, String mime, String content)
        throws IOException
    {
        response.setContentType(mime);
        PrintWriter writer = response.getWriter();
        writer.println(content);
        writer.close();
    }

    //-----------------------------------------------------------------------------------------

    public static void render_image(HttpServletResponse response, BufferedImage image)
        throws IOException
    {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0);
        response.setContentType("image/jpeg");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write(image, "jpg", out);
        out.close();
    }

    //-----------------------------------------------------------------------------------------

    public static OutputStream render_mime(HttpServletResponse response, String filename)
        throws IOException
    {
        String mime = MimeUtils.getMimeByFileName(filename);
        String disp = String.format("attachment; filename=%s", CodecUtils.url_encode(filename));

        OutputStream out = response.getOutputStream();
        response.setContentType(StringUtils.IsEmpty(mime)?MimeUtils.FILE_TYPE_OCTET:mime);
        response.setHeader("Content-Disposition", disp);
        return out;
    }

    public static OutputStream download_mime(HttpServletResponse response, String filename)
        throws IOException
    {
        String mime = MimeUtils.FILE_TYPE_OCTET;
        String disp = String.format("attachment; filename=%s", CodecUtils.url_encode(filename));

        OutputStream out = response.getOutputStream();
        response.setContentType(mime);
        response.setHeader("Content-Disposition", disp);
        return out;
    }

    //-----------------------------------------------------------------------------------------

}
