/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.aspect;

import cc.zuv.lang.StringUtils;
import cc.zuv.utility.KeyGenUtils;
import cc.zuv.web.support.annotation.SysLogRender;
import cc.zuv.web.support.enums.SysLogLevel;
import cc.zuv.web.support.enums.SysLogModule;
import com.google.gson.Gson;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class SysLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SysLogAspect.class);
    private static final String REQUEST_ID = "$request_id";

    @Pointcut(value="@annotation(cc.zuv.web.support.annotation.SysLogRender)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long elapse = System.currentTimeMillis() - beginTime;
        this.saveSysLog(point, elapse);
        return result;
    }

    private void saveSysLog(ProceedingJoinPoint joinPoint, long elapse) {
        Object[] args;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        SysLogRender syslogrender = method.getAnnotation(SysLogRender.class);
        if (syslogrender == null) {
            return;
        }
        SysLogLevel _level = syslogrender.level();
        SysLogModule _module = syslogrender.module();
        String _title = syslogrender.value();
        String _levelstr = syslogrender.levelstr();
        String _modulestr = syslogrender.modulestr();
        String cname = joinPoint.getTarget().getClass().getName();
        String mname = signature.getName();
        String _method = cname + "." + mname + "()";
        String _params = null;
        if ((request.getContentType() == null || "application/x-www-form-urlencoded".contains(request.getContentType()) || "application/json;charset=UTF-8".contains(request.getContentType())) && (args = joinPoint.getArgs()) != null && args.length > 0) {
            _params = new Gson().toJson((Object)args);
        }
        String _hostip = request.getRemoteHost();
        String _requri = request.getRequestURI();
        String _reqmtd = request.getMethod();
        if (StringUtils.NotEmpty((String)_levelstr) && StringUtils.NotEmpty((String)_modulestr)) {
            this.saveSysLog(_levelstr, _modulestr, _title, _method, _params, _hostip, _requri, _reqmtd, elapse);
        } else {
            this.saveSysLog(_level, _module, _title, _method, _params, _hostip, _requri, _reqmtd, elapse);
        }
    }

    protected abstract void saveSysLog(SysLogLevel var1, SysLogModule var2, String var3, String var4, String var5, String var6, String var7, String var8, long var9);

    protected abstract void saveSysLog(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, long var9);

    @Before(value="logPointCut()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestid = KeyGenUtils.uuid();
        request.setAttribute(REQUEST_ID, (Object)requestid);
        String sessionid = request.getSession().getId();
        String requesturi = request.getRequestURI();
        log.info("request: id={}, session= {}, requesturi={}", new Object[]{requestid, sessionid, requesturi});
    }

    @AfterReturning(returning="ret", pointcut="logPointCut()")
    public void doAfterReturning(Object ret) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestid = (String)request.getAttribute(REQUEST_ID);
        String sessionid = request.getSession().getId();
        String retrunval = new Gson().toJson(ret);
        log.info("response: id={}, session= {}, ret={}", new Object[]{requestid, sessionid, retrunval});
    }

    @AfterThrowing(pointcut="logPointCut()", throwing="e")
    public void doAfterThrowing(Exception e) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestid = (String)request.getAttribute(REQUEST_ID);
        String sessionid = request.getSession().getId();
        String message = e.getMessage();
        log.info("throwing: id={}, session= {}, message={}", new Object[]{requestid, sessionid, message});
    }
}

