/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.captcha.kaptcha;

import com.google.code.kaptcha.Producer;
import java.awt.image.BufferedImage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KaptchaService {
    private static final Logger log = LoggerFactory.getLogger(KaptchaService.class);
    private Producer producer;

    public KaptchaService(Producer producer) {
        this.producer = producer;
    }

    public BufferedImage generateCaptcha(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String sessionid = session.getId();
        String captcha = this.producer.createText();
        log.debug("generate captcha {} {}", (Object)sessionid, (Object)captcha);
        session.setAttribute(sessionid, (Object)captcha);
        return this.producer.createImage(captcha);
    }

    public boolean validateCaptcha(HttpServletRequest request, String captcha) {
        HttpSession session = request.getSession();
        String sessionid = session.getId();
        Object value = session.getAttribute(sessionid);
        log.debug("validate captcha {} {} {}", new Object[]{sessionid, captcha, value});
        return value != null && captcha.equalsIgnoreCase((String)value);
    }
}

