/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.exception;

import cc.zuv.lang.StringUtils;
import cc.zuv.web.support.IWebERRCode;
import cc.zuv.web.support.exception.RestAuthorizeException;
import cc.zuv.web.support.exception.RestBadRequestException;
import cc.zuv.web.support.exception.RestDatabaseException;
import cc.zuv.web.support.exception.RestException;
import cc.zuv.web.support.exception.RestHasExistsException;
import cc.zuv.web.support.exception.RestIOException;
import cc.zuv.web.support.exception.RestNotFoundException;
import cc.zuv.web.support.payload.RestResult;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class RestExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);
    @Autowired
    private MessageSource messageSource;

    public String getMessage(String messageKey, Locale locale, Object ... params) {
        return this.messageSource.getMessage(messageKey, params, locale);
    }

    @ExceptionHandler(value={RestException.class})
    public RestResult handleRestException(HttpServletRequest req, RestException e) {
        IWebERRCode errcode = e.getErrcode();
        String message = e.getMessage();
        if (message == null || message.trim().length() == 0) {
            Locale locale = LocaleContextHolder.getLocale();
            message = this.getMessage(errcode.name(), locale, e.getParams());
        }
        return this.getRestResult(errcode, message, req);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={RestDatabaseException.class})
    public RestResult handleDatabaseException(HttpServletRequest req, RestDatabaseException e) {
        return this.getRestResult(HttpStatus.INTERNAL_SERVER_ERROR, 20, e.getMessage(), req);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={RestIOException.class})
    public RestResult handleIOException(HttpServletRequest req, RestIOException e) {
        return this.getRestResult(HttpStatus.INTERNAL_SERVER_ERROR, 21, e.getMessage(), req);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={RestNotFoundException.class})
    public RestResult handleNotFoundException(HttpServletRequest req, RestNotFoundException e) {
        return this.getRestResult(HttpStatus.NOT_FOUND, 18, e.getMessage(), req);
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={RestHasExistsException.class})
    public RestResult handleHasExistsException(HttpServletRequest req, RestHasExistsException e) {
        return this.getRestResult(HttpStatus.CONFLICT, 18, e.getMessage(), req);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={RestBadRequestException.class})
    public RestResult handleBadRequestException(HttpServletRequest req, RestBadRequestException e) {
        return this.getRestResult(HttpStatus.BAD_REQUEST, 16, e.getMessage(), req);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public RestResult handleArgNotValidException(HttpServletRequest req, MethodArgumentNotValidException e) {
        BindingResult result = e.getBindingResult();
        StringBuilder sb = new StringBuilder();
        for (FieldError error : result.getFieldErrors()) {
            String message = String.format("%s:%s ", error.getField(), error.getDefaultMessage());
            sb.append(message).append("\n");
        }
        return this.getRestResult(HttpStatus.BAD_REQUEST, 17, sb.toString(), req);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public RestResult handleMethodNotSupportException(HttpServletRequest req, HttpRequestMethodNotSupportedException e) {
        return this.getRestResult(HttpStatus.BAD_REQUEST, 16, "\u65b9\u6cd5\u4e0d\u652f\u6301", req);
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={RestAuthorizeException.class})
    public RestResult handleAuthorizationException(HttpServletRequest req, RestAuthorizeException e) {
        return this.getRestResult(HttpStatus.UNAUTHORIZED, 19, e.getMessage(), req);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public RestResult handleException(HttpServletRequest req, Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return this.getRestResult(HttpStatus.INTERNAL_SERVER_ERROR, 1, e.getMessage(), req);
    }

    public RestResult<String> getRestResult(HttpStatus _status, int _errcode, String _message, HttpServletRequest _req) {
        String epoint = _req.getRequestURI();
        String method = _req.getMethod();
        String message = StringUtils.NotEmpty((String)_message) ? _message : _status.getReasonPhrase();
        return new RestResult<String>(_status, epoint, method, _errcode, message);
    }

    public RestResult<String> getRestResult(IWebERRCode _errcode, String _message, HttpServletRequest _req) {
        Locale locale = LocaleContextHolder.getLocale();
        String epoint = _req.getRequestURI();
        String method = _req.getMethod();
        HttpStatus status = _errcode.status();
        int errcode = _errcode.errcode();
        String message = StringUtils.NotEmpty((String)_message) ? _message : this.getMessage(_errcode.name(), locale, new Object[0]);
        return new RestResult<String>(status, epoint, method, errcode, message);
    }
}

