/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.jwt;

import cc.zuv.lang.StringUtils;
import cc.zuv.web.support.exception.RestAuthorizeException;
import cc.zuv.web.support.jwt.JwtPayload;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;

public class JwtParser {
    public static final String PARAM_ROLES = "roles";
    public static final String PARAM_PERMS = "perms";

    public static String issueJwt(JwtPayload payload, String secretkey) {
        JwtBuilder jwt = Jwts.builder();
        jwt.setHeaderParam("typ", (Object)"JWT");
        jwt.setId(payload.getId());
        jwt.setSubject(payload.getSubject());
        jwt.setIssuer(payload.getIssuer());
        jwt.setAudience(payload.getAudience());
        jwt.setIssuedAt(payload.getIssuedAt());
        jwt.setExpiration(payload.getExpiration());
        if (StringUtils.NotEmpty((String)payload.getRoles())) {
            jwt.claim(PARAM_ROLES, (Object)payload.getRoles());
        }
        if (StringUtils.NotEmpty((String)payload.getPerms())) {
            jwt.claim(PARAM_PERMS, (Object)payload.getPerms());
        }
        jwt.compressWith(CompressionCodecs.DEFLATE);
        jwt.signWith(SignatureAlgorithm.HS512, secretkey);
        return jwt.compact();
    }

    public static JwtPayload parseJwt(String jwt, String secretkey) {
        JwtPayload payload;
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(secretkey).parseClaimsJws(jwt).getBody();
            payload = new JwtPayload();
            payload.setId(claims.getId());
            payload.setSubject(claims.getSubject());
            payload.setIssuer(claims.getIssuer());
            payload.setIssuedAt(claims.getIssuedAt());
            payload.setAudience(claims.getAudience());
            payload.setExpiration(claims.getExpiration());
            payload.setRoles((String)claims.get(PARAM_ROLES, String.class));
            payload.setPerms((String)claims.get(PARAM_PERMS, String.class));
        }
        catch (ExpiredJwtException e) {
            throw new RestAuthorizeException("JWT \u4ee4\u724c\u8fc7\u671f:" + e.getMessage());
        }
        catch (UnsupportedJwtException e) {
            throw new RestAuthorizeException("JWT \u4ee4\u724c\u65e0\u6548:" + e.getMessage());
        }
        catch (MalformedJwtException e) {
            throw new RestAuthorizeException("JWT \u4ee4\u724c\u683c\u5f0f\u9519\u8bef:" + e.getMessage());
        }
        catch (SignatureException e) {
            throw new RestAuthorizeException("JWT \u4ee4\u724c\u7b7e\u540d\u65e0\u6548:" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RestAuthorizeException("JWT \u4ee4\u724c\u53c2\u6570\u5f02\u5e38:" + e.getMessage());
        }
        catch (Exception e) {
            throw new RestAuthorizeException("JWT \u4ee4\u724c\u9519\u8bef:" + e.getMessage());
        }
        return payload;
    }
}

