/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.storage;

import cc.zuv.web.support.storage.DfsConfig;
import cc.zuv.web.support.storage.DfsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class MvcLocalFileConfig
extends WebMvcConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MvcLocalFileConfig.class);
    @Autowired
    private DfsConfig dfsConfig;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (this.dfsConfig != null && DfsType.LOCAL == this.dfsConfig.getType() && this.dfsConfig.getLocal() != null) {
            String mapping = this.dfsConfig.getLocal().getMapping() + "/**";
            String phypath = "file:" + this.dfsConfig.getLocal().getPhypath() + "/";
            if (!registry.hasMappingForPattern(mapping)) {
                log.info("add mapping {} to {}", (Object)mapping, (Object)phypath);
                registry.addResourceHandler(new String[]{mapping}).addResourceLocations(new String[]{phypath});
                super.addResourceHandlers(registry);
            }
        }
    }
}

