/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.utility;

import cc.zuv.lang.StringUtils;
import cc.zuv.utility.CodecUtils;
import cc.zuv.utility.MimeUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class HttpRenderUtils {
    public static void render_html(HttpServletResponse response, String html) throws IOException {
        HttpRenderUtils.render_content(response, "text/html; charset=utf-8", html);
    }

    public static void render_text(HttpServletResponse response, String txt) throws IOException {
        HttpRenderUtils.render_content(response, "text/plain; charset=utf-8", txt);
    }

    public static void render_xml(HttpServletResponse response, String xml) throws IOException {
        HttpRenderUtils.render_content(response, "text/xml; charset=utf-8", xml);
    }

    public static void render_json(HttpServletResponse response, String json) throws IOException {
        HttpRenderUtils.render_content(response, "application/json; charset=utf-8", json);
    }

    private static void render_content(HttpServletResponse response, String mime, String content) throws IOException {
        response.setContentType(mime);
        PrintWriter writer = response.getWriter();
        writer.println(content);
        writer.close();
    }

    public static void render_image(HttpServletResponse response, BufferedImage image) throws IOException {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
        out.close();
    }

    public static OutputStream render_mime(HttpServletResponse response, String filename) throws IOException {
        String mime = MimeUtils.getMimeByFileName((String)filename);
        String disp = String.format("attachment; filename=%s", CodecUtils.url_encode((String)filename));
        ServletOutputStream out = response.getOutputStream();
        response.setContentType(StringUtils.IsEmpty((String)mime) ? "application/octet-stream" : mime);
        response.setHeader("Content-Disposition", disp);
        return out;
    }

    public static OutputStream download_mime(HttpServletResponse response, String filename) throws IOException {
        String mime = "application/octet-stream";
        String disp = String.format("attachment; filename=%s", CodecUtils.url_encode((String)filename));
        ServletOutputStream out = response.getOutputStream();
        response.setContentType(mime);
        response.setHeader("Content-Disposition", disp);
        return out;
    }
}

