/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.utility;

import cc.zuv.lang.StringUtils;
import javax.servlet.http.HttpServletRequest;

public class WebsPathUtils {
    public static String getServerUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        String header_scheme = request.getHeader("X-Forwarded-Proto");
        if (StringUtils.NotEmpty((String)header_scheme) && ("http".equalsIgnoreCase(header_scheme) || "https".equalsIgnoreCase(header_scheme))) {
            scheme = header_scheme;
        }
        return scheme + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.IsEmpty((String)ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.IsEmpty((String)ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.IsEmpty((String)ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getServletPath(HttpServletRequest request) {
        return request.getSession().getServletContext().getRealPath("");
    }
}

