/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.web.support.validator;

import cc.zuv.web.support.exception.RestBadRequestException;
import cc.zuv.web.support.exception.RestHasExistsException;
import cc.zuv.web.support.exception.RestNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertUtil {
    private static final Logger log = LoggerFactory.getLogger(AssertUtil.class);

    public static void assertTrue(boolean value, String message) {
        if (value) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertBetween(byte min, byte max, byte value, String message) {
        if (value < min || value >= max) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertBetween(int min, int max, int value, String message) {
        if (value < min || value >= max) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertBlank(String value, String message) {
        if (value == null || value.trim().length() == 0) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNull(Object value, String message) {
        if (value == null) {
            throw new RestBadRequestException(message);
        }
    }

    public static void assertNotFound(Object value, String message) {
        if (value == null) {
            throw new RestNotFoundException(message);
        }
    }

    public static void assertHasExist(Object value, String message) {
        if (value != null) {
            throw new RestHasExistsException(message);
        }
    }
}

