/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.jwt.JwtPayload:20190102094418
 *
 * JwtPayload.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.jwt;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Date;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Getter
@Setter
@NoArgsConstructor
public class JwtPayload
{

    //-----------------------------------------------------------------------------------------

    private String id;
    private String subject;     //主题(用户)
    private String issuer;      //签发人
    private String audience;    //接收方
    private Date issuedAt;      //签发时间
    private Date expiration;    //过期时间
    private String roles;
    private String perms;

    //-----------------------------------------------------------------------------------------

    public boolean isExpired()
    {
        return expiration.before(new Date());
    }

    //-----------------------------------------------------------------------------------------

}
