/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.utility.CookieUtils:20190513213618
 *
 * CookieUtils.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.utility;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-05-13 21:36
 * @modify.date     2019-05-13 21:36
 */
public class CookieUtils
{

    //-----------------------------------------------------------------------------------------

    public static void setCookie(HttpServletResponse res, String name,
                                 String value, String domain)
    {
        setCookie(res, name, value, 60 * 60 * 12, domain);
    }

    public static void setCookie(HttpServletResponse res, String name,
                                 String value, int empiry, String domain)
    {
        Cookie _cookie = new Cookie(name, value);
        if(domain!=null) _cookie.setDomain(domain); // 注意域名必须以点开始,如果没有设置域,那么COOKIE就只和创建该COOKIE的服务器相关
        _cookie.setMaxAge(empiry); // 以秒计算,默认值为-1,表示浏览器退出时,该COOKIE立即失效.
        _cookie.setPath("/"); // "/"表示服务器上所有目录都可以使用该COOKIE.
        // _cookie.setSecure(secure);//指出浏览器使用的安全协议，例如HTTPS或SSL。
        res.addCookie(_cookie);
    }

    public static void delCookie(HttpServletResponse res, String name,
                                 String domain)
    {
        Cookie _cookie = new Cookie(name, null);
        if(domain!=null) _cookie.setDomain(domain);
        _cookie.setMaxAge(0);// 0表示删除、-1表示浏览器关闭立即删除
        _cookie.setPath("/");
        res.addCookie(_cookie);
    }

    public static String getCookie(HttpServletRequest req, String name)
    {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) return null;

        String out = null;
        int len = cookies.length;
        for (int i = 0; i < len; i++)
        {
            Cookie cookie = cookies[i];
            if (name.equals(cookie.getName()))
            {
                out = cookie.getValue();
                break;
            }
        }
        return out;
    }

    //判断是否支持cookie
    public static boolean isSupportCookie(HttpServletRequest req, HttpServletResponse res)
    {
        res.addCookie(new Cookie("cookiesupport", "true"));
        Cookie[] cookies = req.getCookies();
        return (cookies != null && cookies.length > 0);
    }

    //-----------------------------------------------------------------------------------------


}
