/*
 * Id$: zuv-cloud:z-web-support:cc.zuv.web.support.session.RedisSessionConfig:20190101141337
 *
 * RedisSessionConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.web.support.session;

import org.springframework.context.annotation.Configuration;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;

/**
 * Redis会话
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Configuration
@EnableRedisHttpSession(maxInactiveIntervalInSeconds = 86400*30)
public class RedisSessionConfig
{

    //-----------------------------------------------------------------------------------------

    //maxInactiveIntervalInSeconds: 设置Session失效时间
    //使用Redis Session之后，原Boot的server.session.timeout属性不再生效

    //-----------------------------------------------------------------------------------------

}
